#include <stdio.h>
#include <stdlib.h>
int simulate_tournament(int *strengths, int mi, int ji, int N) {
    int *temp = (int *)malloc(N * sizeof(int));
    for (int i = 0; i < N; i++) {
        temp[i] = strengths[i];
    }
    int replaced_strength = temp[mi - 1];
    temp[mi - 1] = temp[ji - 1];
    temp[ji - 1] = replaced_strength;
    int rounds = 0;
    while (N > 1) {
        rounds++;
        int *winners = (int *)malloc((N / 2 + N % 2) * sizeof(int));
        int index = 0;
        for (int i = 0; i < N; i += 2) {
            if (i + 1 < N) {
                winners[index++] = (temp[i] > temp[i + 1]) ? temp[i] : temp[i + 1];
            } else {
                winners[index++] = temp[i];
            }
        }
        N = index;
        free(temp);
        temp = winners;
    }
    free(temp);
    return rounds - 1;
}
void calculate_highest_round(int N, int *strengths, int options[][2], int Q, int *highest_rounds) {
    for (int i = 0; i < Q; i++) {
        int mi = options[i][0], ji = options[i][1];
        highest_rounds[i] = simulate_tournament(strengths, mi, ji, N);
    }
}
int main() {
    int N;
    scanf("%d", &N);
    int strengths[N];
    for (int i = 0; i < N; i++) {
        scanf("%d", &strengths[i]);
    }
    int Q;
    scanf("%d", &Q);
    int options[Q][2];
    for (int i = 0; i < Q; i++) {
        scanf("%d %d", &options[i][0], &options[i][1]);
    }
    int highest_rounds[Q];
    calculate_highest_round(N, strengths, options, Q, highest_rounds);
    for (int i = 0; i < Q; i++) {
        printf("%d\n", highest_rounds[i]);
    }
    return 0;
}